Scriptname _SLSubmitAmbushEffect extends activemagiceffect  

_SLSubmitConfig Property _SLConfig auto
_SLSubmitFunctions Property _SLFunctions auto
_SLSubmitQuest Property _SLQuest auto
_SLSubmitScene Property _SLScene auto
PlayerVampireQuestScript Property PVQ Auto
Keyword Property ActorTypeNPC  Auto  

Int Property Gold  Auto  
MiscObject Property Gold001  Auto  
SexLabFramework Property SexLab  Auto  
GlobalVariable Property _SLSubmitAmbushGlobal  Auto  
GlobalVariable Property AttemptCost  Auto  
GlobalVariable Property SuccessChance  Auto  
GlobalVariable Property SuccessRoll  Auto  
Idle Property _SLSubmitAmbush  Auto  
Idle Property _SLSubmitSmack  Auto  
float Property THealth  Auto
Spell Property _SLSubmitGuard  Auto  
Weapon Property TargetWeapon1  Auto  
Weapon Property TargetWeapon2  Auto  
Spell Property _SLSubmitUnarmed  Auto  
Spell Property _SLSubmitCalm Auto
Topic Property _SLSubmitAmbushSayTopic Auto
Topic Property _SLSubmitSay1Topic Auto
Topic Property _SLSubmitSay2Topic Auto
Topic Property _SLSubmitSay3Topic Auto
Keyword Property Vampire Auto
ReferenceAlias Property ActorVictim  Auto  
Faction Property _SLSubmitFaction Auto
Faction Property _SLSubmitRecoverFaction Auto
Faction Property _SLSubmitBountyFaction Auto
Spell Property Slap Auto
Actor Property PlayerRef Auto

Event OnEffectStart(actor Target, actor Caster)
	If ((!Target.HasLOS(Caster) || Target.GetSleepState() == 3) && Target.HasKeyword(ActorTypeNPC))
; // Code for the success algorithm
		Target.GetLeveledActorBase().SetProtected()
		PlayerRef.DamageAV("Stamina",AttemptCost.GetValue())
		THealth = Target.GetAV("Health")/Target.GetBaseAV("Health")*100
		_SLQuest.GatherStats(Target,Caster)
		If (Target.GetSleepState() == 3)
			_SLQuest.AmbushSleepChance()
		Else
			_SLQuest.AmbushChance()
		EndIf
		Target.Say(_SLSubmitAmbushSayTopic)
; // Code for what happens on success
		If (SuccessChance.GetValue() >= SuccessRoll.GetValue())
			If (!Target.IsInFaction(_SLSubmitRecoverFaction))
				Target.AddToFaction(_SLSubmitRecoverFaction)
			EndIf
			If(_SLConfig.debugActive)
				Debug.Notification(SuccessChance.GetValue() + "% success chance, " + SuccessRoll.GetValue() + "% rolled.  Target submits!")
			EndIf
			ActorVictim.ForceRefTo(Target)
			If (!Target.IsInFaction(_SLSubmitFaction))
				Target.AddToFaction(_SLSubmitFaction)
			EndIf
			_SLSubmitCalm.Cast(Target)
			TargetWeapon1 = Target.getEquippedWeapon()
			TargetWeapon2 = Target.getEquippedWeapon(True)
			If(PlayerRef.IsTrespassing())
				Target.SetRelationshipRank(PlayerRef,1)
			EndIf
			Game.DisablePlayerControls()
			_SLFunctions.UnArm(Caster)
			_SLScene.WRT(0.2)
			If !Caster.IsWeaponDrawn()		
				Caster.DrawWeapon()	
				_SLScene.WRT(0.5)
			EndIf
			If (Caster.HasKeyword(Vampire) && _SLConfig.VampireActive)
				If (Target.GetSleepState() == 3)
					Caster.StartVampireFeed(Target)
					_SLFunctions.SubmitFeed()
					Target.StopCombat()
				ElseIf (Target.GetSitState() == 3)
					Debug.SendAnimationEvent(Target, "IdleForceDefaultState")
					Caster.PlayIdleWithTarget(_SLSubmitAmbush, Target)
					_SLFunctions.SubmitFeed()
					Target.StopCombat()
					Debug.SendAnimationEvent(Target, "IdleForceDefaultState")
				Else
					Debug.SendAnimationEvent(Target, "IdleForceDefaultState")
					Caster.StartVampireFeed(Target)
					_SLFunctions.SubmitFeed()
					Target.StopCombat()
				EndIf
			Else
				Debug.SendAnimationEvent(Target, "IdleForceDefaultState")
				If (Target.GetSleepState() == 3)
					Target.MoveTo(Target, 200.0 * Math.Sin(Target.GetAngleZ()), 200.0 * Math.Cos(Target.GetAngleZ()))
					Caster.MoveTo(Target, -30.0 * Math.Sin(Target.GetAngleZ()), -30.0 * Math.Cos(Target.GetAngleZ()))
				EndIf
				_SLScene.WRT(0.1)
				If (Caster.IsSneaking())
					Caster.StartSneaking()
				EndIf
				If (!Target.HasLOS(Caster))
					Caster.PlayIdleWithTarget(_SLSubmitAmbush, Target)
					_SLScene.WRT(4.0)
				Else
					Slap.Cast(Caster)
					Target.MoveTo(Caster, 15.0 * Math.Sin(Caster.GetAngleZ()), 15.0 * Math.Cos(Caster.GetAngleZ()))
					Debug.SendAnimationEvent(Caster, "AttackStartH2HLeft")
					_SLScene.WRT(0.4)
					Caster.PlayIdleWithTarget(_SLSubmitSmack, Target)
					_SLScene.WRT(2.2)
				EndIf
				Debug.SendAnimationEvent(Target, "IdleForceDefaultState")
			EndIf
			If (!Caster.IsSneaking())
				_SLScene.WRT(0.5)
				Caster.StartSneaking()
			EndIf
			If (TargetWeapon1 != none)
				Target.RemoveItem(TargetWeapon1, 1, false, Caster)
				Debug.Notification("You have disarmed " + Target.GetLeveledActorBase().GetName() + " and taken their " + TargetWeapon1.GetName() + "!")
			EndIf
			If (TargetWeapon2 != none)
				Target.RemoveItem(TargetWeapon2, 1, false, Caster)
				Debug.Notification("You have disarmed " + Target.GetLeveledActorBase().GetName() + " and taken their " + TargetWeapon2.GetName() + "!")
			EndIf
			_SLScene.WRT(0.1)
			Debug.SendAnimationEvent(Target, "BleedOutStart")
			Game.EnablePlayerControls()
			Target.Say(_SLSubmitSay3Topic)
			Target.StopCombat()				
			If Caster.IsWeaponDrawn()		
				Caster.SheatheWeapon()	
				_SLScene.WRT(0.1)
			EndIf
			_SLFunctions.ReArm(Caster)
			If !Caster.IsWeaponDrawn()		
				Caster.DrawWeapon()	
			EndIf
			_SLScene.WRT(0.5)
			If (Caster.HasKeyword(Vampire) && _SLConfig.VampireActive)
				If (Target.GetSleepState() == 3)
					PVQ.VampireProgression(PlayerRef, 1)
				Else
					PVQ.VampireProgression(PlayerRef, 1)
					_SLScene.WRT(2.0)
				EndIf
			Else
				_SLScene.WRT(2.0)
			EndIf
			Target.Say(_SLSubmitSay2Topic)
			If (Target.IsInFaction(_SLSubmitRecoverFaction))
				Target.RemoveFromFaction(_SLSubmitRecoverFaction)
			EndIf
			If (!Target.IsInFaction(_SLSubmitBountyFaction) && _SLQuest.IsHostileNPC(Target))
				Target.AddToFaction(_SLSubmitBountyFaction)
			EndIf
			_SLScene.Strip(Target)
			If(_SLConfig.RobActive)
				_SLScene.Rob(Target,Caster)
			EndIf
			If(_SLConfig.RapeActive && _SLConfig.AmbushSexActive)
				Target.Say(_SLSubmitSay1Topic)
				_SLScene.WRT(0.5)
				_SLScene.Sex(Target,Caster)
			Else
				_SLScene.PostRob(Target,Caster)
			EndIf
		Else
; // Code for what happens on failure
			If(_SLConfig.debugActive)
				Debug.Notification(SuccessChance.GetValue() + "% success chance, " + SuccessRoll.GetValue() + "% rolled.  Target resists!")
			EndIf
			Debug.SendAnimationEvent(Target, "IdleForceDefaultState")
			If (Caster.IsSneaking())
				Caster.StartSneaking()
			EndIf
			_SLScene.WRT(0.1)
			float zOffset = Target.GetHeadingAngle(Caster)
			Target.SetAngle(Caster.GetAngleX(), Caster.GetAngleY(), Caster.GetAngleZ() + zOffset)
			Target.SetRelationshipRank(Caster,-2)
			_SLScene.WRT(0.1)
			Debug.SendAnimationEvent(Target, "StaggerStart")
			Debug.SendAnimationEvent(Caster, "StaggerStart")
			_SLScene.WRT(1.0)
			If !Caster.IsWeaponDrawn()		
				Caster.DrawWeapon()	
			EndIf
			_SLScene.WRT(0.1)
			Target.SendAssaultAlarm()
			Target.startCombat(Caster)
		EndIf
	EndIf
EndEvent